#region References

using System;
using System.Collections;
using System.Windows.Forms;

using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.GUI;

#endregion

namespace gov.va.med.vbecs.admin.GUI
{
	/// <summary>
	/// Class EditVbecsUserDivisionalAccess
	/// </summary>
	public class EditVbecsUserDivisionalAccess : gov.va.med.vbecs.admin.GUI.BaseAdminFormControl
	{
		#region Variables

		private const int UserDivisionRolesListViewColumnWidthAdjustment = 10;

		private VbecsUser _vbecsUser;
		private VbecsVistAUser _vistAUser;

		private bool _firstTimeVisibilityChange;

		private System.Windows.Forms.GroupBox grpDivisionalAccess;
		private System.Windows.Forms.Button btnUpdate;
		private System.Windows.Forms.ComboBox cmbDivisionName;
		private System.Windows.Forms.ListView lvUserDivisionRoles;
		private System.Windows.Forms.Label lblUserRole;
		private System.Windows.Forms.Label lblDivisionCode;
		private System.Windows.Forms.Label lblDivisionName;
		private System.Windows.Forms.ColumnHeader colActive;
		private System.Windows.Forms.ColumnHeader colDivisionName;
		private System.Windows.Forms.ColumnHeader colUserRole;
		private System.Windows.Forms.GroupBox grpDivisionAccessSplitter;
		private System.Windows.Forms.Button btnVistaDivisions;
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// ControlDataChanged
		/// </summary>
		public event EventHandler ControlDataChanged;

		/// <summary>
		/// cmbDivisionCode
		/// </summary>
		public System.Windows.Forms.ComboBox cmbDivisionCode;

		/// <summary>
		/// cbActiveUserRole
		/// </summary>
		public System.Windows.Forms.CheckBox cbActiveUserRole;

		/// <summary>
		/// cmbUserRole
		/// </summary>
		public System.Windows.Forms.ComboBox cmbUserRole;

		#endregion

		#region DivisionRoleListViewItem implementation

		/// <summary>
		/// Class DivisionRoleListViewItem
		/// </summary>
		protected class DivisionRoleListViewItem : BaseListViewItem
		{			
			private enum DivRolesSubItemsIndex : int
			{
				DivisionName = 1,
				UserRole
			};
			
			private static readonly int _numberOfSubItems;
			private static readonly Hashtable _allItems;

			private VbecsUserDivisionRole _divisionRole;

			/// <summary>
			/// Static Constructor
			/// </summary>
			static DivisionRoleListViewItem()
			{
				_numberOfSubItems = Enum.GetValues( typeof(DivRolesSubItemsIndex) ).Length;
				_allItems = new Hashtable();
			}

			/// <summary>
			/// Constructor
			/// </summary>
			/// <param name="divisionRole"></param>
			public DivisionRoleListViewItem( VbecsUserDivisionRole divisionRole ) 
				: base( _numberOfSubItems )
			{
				if( divisionRole == null )
					throw( new ArgumentNullException( "divisionRole" ) );

				_divisionRole = divisionRole;

				SyncWithDataObject();

				lock( typeof( VbecsUserDivisionRole ) )
					if( _allItems.ContainsKey( divisionRole ) )
						_allItems[ divisionRole ] = this;
					else
						_allItems.Add( divisionRole, this );
			}

			/// <summary>
			/// SyncWithDataObject
			/// </summary>
			public override void SyncWithDataObject()
			{
				if( this.Checked != _divisionRole.IsActive ) // to prevent self-calling
					this.Checked = _divisionRole.IsActive;

				this.SubItems[ (int)DivRolesSubItemsIndex.DivisionName ].Text = _divisionRole.Division.DivisionName;	 
				this.SubItems[ (int)DivRolesSubItemsIndex.UserRole ].Text = _divisionRole.Role.UserRoleName;

				SetStatusForeColor( _divisionRole.IsActive );
			}

			/// <summary>
			/// Get DivisionRole
			/// </summary>
			public VbecsUserDivisionRole DivisionRole
			{
				get
				{
					return _divisionRole;
				}
			}

			/// <summary>
			/// DivisionRoleListViewItem
			/// </summary>
			/// <param name="divisionRole"></param>
			/// <returns></returns>
			public static DivisionRoleListViewItem GetListViewItemByDivisionRole( VbecsUserDivisionRole divisionRole )
			{
				if( divisionRole == null )
					throw( new ArgumentNullException( "divisionRole" ) );

				lock( typeof( DivisionRoleListViewItem ) )
					return (DivisionRoleListViewItem)_allItems[ divisionRole ];
			}

			/// <summary>
			/// ClearAllItems
			/// </summary>
			public static void ClearAllItems()
			{
				_allItems.Clear();
			}
		}

		#endregion		

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.grpDivisionalAccess = new System.Windows.Forms.GroupBox();
			this.cmbDivisionCode = new System.Windows.Forms.ComboBox();
			this.cbActiveUserRole = new System.Windows.Forms.CheckBox();
			this.lblUserRole = new System.Windows.Forms.Label();
			this.cmbUserRole = new System.Windows.Forms.ComboBox();
			this.btnUpdate = new System.Windows.Forms.Button();
			this.cmbDivisionName = new System.Windows.Forms.ComboBox();
			this.grpDivisionAccessSplitter = new System.Windows.Forms.GroupBox();
			this.lvUserDivisionRoles = new System.Windows.Forms.ListView();
			this.colActive = new System.Windows.Forms.ColumnHeader();
			this.colDivisionName = new System.Windows.Forms.ColumnHeader();
			this.colUserRole = new System.Windows.Forms.ColumnHeader();
			this.lblDivisionCode = new System.Windows.Forms.Label();
			this.lblDivisionName = new System.Windows.Forms.Label();
			this.btnVistaDivisions = new System.Windows.Forms.Button();
			this.grpDivisionalAccess.SuspendLayout();
			this.SuspendLayout();
			// 
			// grpDivisionalAccess
			// 
			this.grpDivisionalAccess.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDivisionalAccess.Controls.Add(this.btnVistaDivisions);
			this.grpDivisionalAccess.Controls.Add(this.cmbDivisionCode);
			this.grpDivisionalAccess.Controls.Add(this.cbActiveUserRole);
			this.grpDivisionalAccess.Controls.Add(this.lblUserRole);
			this.grpDivisionalAccess.Controls.Add(this.cmbUserRole);
			this.grpDivisionalAccess.Controls.Add(this.btnUpdate);
			this.grpDivisionalAccess.Controls.Add(this.cmbDivisionName);
			this.grpDivisionalAccess.Controls.Add(this.grpDivisionAccessSplitter);
			this.grpDivisionalAccess.Controls.Add(this.lvUserDivisionRoles);
			this.grpDivisionalAccess.Controls.Add(this.lblDivisionCode);
			this.grpDivisionalAccess.Controls.Add(this.lblDivisionName);
			this.grpDivisionalAccess.Location = new System.Drawing.Point(0, 0);
			this.grpDivisionalAccess.Name = "grpDivisionalAccess";
			this.grpDivisionalAccess.Size = new System.Drawing.Size(574, 144);
			this.grpDivisionalAccess.TabIndex = 16;
			this.grpDivisionalAccess.TabStop = false;
			this.grpDivisionalAccess.Text = "Divisional Access";
			// 
			// cmbDivisionCode
			// 
			this.cmbDivisionCode.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.cmbDivisionCode.Location = new System.Drawing.Point(90, 24);
			this.cmbDivisionCode.Name = "cmbDivisionCode";
			this.cmbDivisionCode.Size = new System.Drawing.Size(142, 21);
			this.cmbDivisionCode.TabIndex = 0;
			this.cmbDivisionCode.SelectedIndexChanged += new System.EventHandler(this.cmbDivisionCode_SelectedIndexChanged);
			// 
			// cbActiveUserRole
			// 
			this.cbActiveUserRole.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbActiveUserRole.Location = new System.Drawing.Point(12, 112);
			this.cbActiveUserRole.Name = "cbActiveUserRole";
			this.cbActiveUserRole.Size = new System.Drawing.Size(92, 20);
			this.cbActiveUserRole.TabIndex = 3;
			this.cbActiveUserRole.Text = "Active Role?";
			// 
			// lblUserRole
			// 
			this.lblUserRole.Location = new System.Drawing.Point(12, 88);
			this.lblUserRole.Name = "lblUserRole";
			this.lblUserRole.Size = new System.Drawing.Size(72, 20);
			this.lblUserRole.TabIndex = 27;
			this.lblUserRole.Text = "User Role*";
			this.lblUserRole.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cmbUserRole
			// 
			this.cmbUserRole.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.cmbUserRole.Location = new System.Drawing.Point(90, 88);
			this.cmbUserRole.Name = "cmbUserRole";
			this.cmbUserRole.Size = new System.Drawing.Size(170, 21);
			this.cmbUserRole.TabIndex = 2;
			this.cmbUserRole.SelectedIndexChanged += new System.EventHandler(this.cmbUserRole_SelectedIndexChanged);
			// 
			// btnUpdate
			// 
			this.btnUpdate.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.btnUpdate.Location = new System.Drawing.Point(185, 114);
			this.btnUpdate.Name = "btnUpdate";
			this.btnUpdate.TabIndex = 4;
			this.btnUpdate.Text = "&Update";
			this.btnUpdate.Click += new System.EventHandler(this.btnUpdate_Click);
			// 
			// cmbDivisionName
			// 
			this.cmbDivisionName.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.cmbDivisionName.Location = new System.Drawing.Point(90, 48);
			this.cmbDivisionName.Name = "cmbDivisionName";
			this.cmbDivisionName.Size = new System.Drawing.Size(170, 21);
			this.cmbDivisionName.TabIndex = 1;
			this.cmbDivisionName.SelectedIndexChanged += new System.EventHandler(this.cmbDivisionName_SelectedIndexChanged);
			// 
			// grpDivisionAccessSplitter
			// 
			this.grpDivisionAccessSplitter.Location = new System.Drawing.Point(12, 74);
			this.grpDivisionAccessSplitter.Name = "grpDivisionAccessSplitter";
			this.grpDivisionAccessSplitter.Size = new System.Drawing.Size(248, 4);
			this.grpDivisionAccessSplitter.TabIndex = 31;
			this.grpDivisionAccessSplitter.TabStop = false;
			// 
			// lvUserDivisionRoles
			// 
			this.lvUserDivisionRoles.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvUserDivisionRoles.CheckBoxes = true;
			this.lvUserDivisionRoles.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																								  this.colActive,
																								  this.colDivisionName,
																								  this.colUserRole});
			this.lvUserDivisionRoles.FullRowSelect = true;
			this.lvUserDivisionRoles.HideSelection = false;
			this.lvUserDivisionRoles.Location = new System.Drawing.Point(270, 16);
			this.lvUserDivisionRoles.MultiSelect = false;
			this.lvUserDivisionRoles.Name = "lvUserDivisionRoles";
			this.lvUserDivisionRoles.Size = new System.Drawing.Size(296, 122);
			this.lvUserDivisionRoles.TabIndex = 14;
			this.lvUserDivisionRoles.View = System.Windows.Forms.View.Details;
			this.lvUserDivisionRoles.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvUserDivisionRoles_ItemCheck);
			this.lvUserDivisionRoles.SelectedIndexChanged += new EventHandler(lvUserDivisionRoles_SelectedIndexChanged);
			// 
			// colActive
			// 
			this.colActive.Text = "Active";
			this.colActive.Width = 45;
			// 
			// colDivisionName
			// 
			this.colDivisionName.Text = "Division Name";
			this.colDivisionName.Width = 115;
			// 
			// colUserRole
			// 
			this.colUserRole.Text = "User Role";
			this.colUserRole.Width = 130;
			// 
			// lblDivisionCode
			// 
			this.lblDivisionCode.Location = new System.Drawing.Point(12, 24);
			this.lblDivisionCode.Name = "lblDivisionCode";
			this.lblDivisionCode.Size = new System.Drawing.Size(80, 20);
			this.lblDivisionCode.TabIndex = 24;
			this.lblDivisionCode.Text = "Division Code*";
			this.lblDivisionCode.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblDivisionName
			// 
			this.lblDivisionName.Location = new System.Drawing.Point(12, 48);
			this.lblDivisionName.Name = "lblDivisionName";
			this.lblDivisionName.Size = new System.Drawing.Size(88, 20);
			this.lblDivisionName.TabIndex = 25;
			this.lblDivisionName.Text = "Division Name*";
			this.lblDivisionName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnVistaDivisions
			// 
			this.btnVistaDivisions.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)));
			this.btnVistaDivisions.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnVistaDivisions.Location = new System.Drawing.Point(236, 24);
			this.btnVistaDivisions.Name = "btnVistaDivisions";
			this.btnVistaDivisions.Size = new System.Drawing.Size(24, 22);
			this.btnVistaDivisions.TabIndex = 32;
			this.btnVistaDivisions.Text = "...";
			this.btnVistaDivisions.Click += new EventHandler(btnVistaDivisions_Click);
			// 
			// EditVbecsUserDivisionalAccess
			// 
			this.Controls.Add(this.grpDivisionalAccess);
			this.Name = "EditVbecsUserDivisionalAccess";
			this.Size = new System.Drawing.Size(574, 144);
			this.grpDivisionalAccess.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Constructors / Dispose

		/// <summary>
		/// Constructor
		/// </summary>
		public EditVbecsUserDivisionalAccess()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			cmbDivisionCode.Sorted = cmbDivisionName.Sorted = true;
			_firstTimeVisibilityChange = true;					
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		/// <summary>
		/// </summary>
		protected override void OnLoad(EventArgs e)
		{
			base.OnLoad (e);

#if !DESIGN	
			using( new WaitCursor() )
				GuiUtility.PopulateComboBoxFromList( cmbUserRole, UserRole.GetAll(), "UserRoleName" );

			ResetUiToNoSelection();
#endif
		}

		/// <summary>
		/// </summary>
		protected override void OnVisibleChanged(EventArgs e)
		{
			base.OnVisibleChanged (e);

			if( !_firstTimeVisibilityChange )
				return;

			_firstTimeVisibilityChange = false;
			AdjustDivisionsListViewColumns();
		}

		/// <summary>
		/// </summary>
		private void AdjustDivisionsListViewColumns()
		{
			colDivisionName.Width = colUserRole.Width = ( lvUserDivisionRoles.Width - colActive.Width - UserDivisionRolesListViewColumnWidthAdjustment ) / 2;
		}

		/// <summary>
		/// </summary>
		private void cmbDivisionCode_SelectedIndexChanged(object sender, EventArgs e)
		{	
			cmbDivisionName.SelectedItem = cmbDivisionCode.SelectedItem;

			if( DataLoadMode.IsLocked )
				return;

			VbecsUserDivisionRole _existingDivisionRole = _vbecsUser.DivisionsAndRoles[ ((DivisionDefinition)cmbDivisionCode.SelectedItem).DivisionCode ];

			if( _existingDivisionRole != null )
				SelectUserDivisionRole( _existingDivisionRole );
			else
				UpdateDisplayForNewRoleDefinition();
		}

		/// <summary>
		/// </summary>
		private void cmbDivisionName_SelectedIndexChanged(object sender, EventArgs e)
		{
			if( DataLoadMode.IsLocked || cmbDivisionCode.SelectedItem == cmbDivisionName.SelectedItem )
				return;

			cmbDivisionCode.SelectedItem = cmbDivisionName.SelectedItem;
		}

		/// <summary>
		/// </summary>
		private void cmbUserRole_SelectedIndexChanged(object sender, EventArgs e)
		{
			if( DataLoadMode.IsLocked )
				return;

			UpdateDynamicallyEnabled();
		}

		/// <summary>
		/// Configures controls for "VistA division selected, but no role for it is defined in the VBECS yet".
		/// </summary>
		private void UpdateDisplayForNewRoleDefinition()
		{
			if( DataLoadMode.IsLocked )
				return;

			DataLoadMode.Lock();

			cmbUserRole.SelectedItem = null;
			cbActiveUserRole.Checked = true;	
			lvUserDivisionRoles.SelectedItems.Clear();
			
			DataLoadMode.Release();

			UpdateDynamicallyEnabled();
		}

		/// <summary>
		/// Updates role combobox and active checkbox depending on the role selection.
		/// </summary>
		private void UpdateDynamicallyEnabled()
		{
			bool _divisionsAvailable = ( cmbDivisionCode.Items.Count > 0 );

			cmbDivisionCode.Enabled = cmbDivisionName.Enabled = _divisionsAvailable;

			bool _divisionSelected = _divisionsAvailable & ( cmbDivisionCode.SelectedItem != null );

			cmbUserRole.Enabled = _divisionSelected;

			bool _divisionRoleSelected = ( _divisionSelected && cmbUserRole.SelectedItem != null );

			cbActiveUserRole.Enabled = lblUserRole.Enabled = _divisionRoleSelected;
			btnUpdate.Enabled = _divisionRoleSelected;
			btnVistaDivisions.Enabled = ( _vbecsUser != null && _vistAUser != null );
		}

		/// <summary>
		/// </summary>
		protected virtual void ResetUiToNoSelection()
		{			
			ResetWidgetsToDefaultValues();
			UpdateDynamicallyEnabled();
			
			grpDivisionalAccess.Enabled = false;
		}

		/// <summary>
		/// Resets all controls to "no user specified, nothing is selected" state.
		/// </summary>
		protected virtual void ResetWidgetsToDefaultValues()
		{
			DataLoadMode.Lock();

			cmbDivisionCode.Items.Clear();
			cmbDivisionName.Items.Clear();
			cmbUserRole.SelectedItem = null;
			cbActiveUserRole.Checked = false;
			
			ClearUserDivisionRolesListViewItems();			

			DataLoadMode.Release();
		}

		/// <summary>
		/// Resets controls and sets state for "user specified, but no division role is selected" state. 
		/// </summary>
		private void ResetToNoDivisionRoleSelected()
		{
			DataLoadMode.Lock();

			cmbDivisionCode.SelectedItem = cmbUserRole.SelectedItem = null;
			cbActiveUserRole.Checked = false;
			lvUserDivisionRoles.SelectedItems.Clear();

			DataLoadMode.Release();

			UpdateDynamicallyEnabled();
		}

		/// <summary>
		/// Resets and disables everything to "no user specified state".
		/// </summary>
		public void ResetToNoUserSelected()
		{
			_vistAUser = null;
			_vbecsUser = null;

			ResetUiToNoSelection();
		}

		/// <summary>
		/// </summary>
		public void SelectUser( VbecsVistAUser vistaUser, VbecsUser vbecsUser )
		{
			if( vbecsUser == null )
			{
				ResetToNoUserSelected();
				return;
			}

			_vistAUser = vistaUser;
			_vbecsUser = vbecsUser;

			ResetWidgetsToDefaultValues();
			PopulateUserDivisionsList();
			PopulateUserVbecsDivisionRolesList();

			grpDivisionalAccess.Enabled = true;

			UpdateDynamicallyEnabled();
		}			
		
		/// <summary>
		/// </summary>
		private void PopulateUserVbecsDivisionRolesList()
		{
			DataLoadMode.Lock();

			ClearUserDivisionRolesListViewItems();

			if (_vistAUser != null && _vistAUser.AvailableDivisionsHashedByCode != null)
			{
				foreach(VbecsUserDivisionRole _divRole in _vbecsUser.DivisionsAndRoles)
				{
					foreach(DivisionDefinition entry in _vistAUser.AvailableDivisionsHashedByCode.Values)
					{
						if(_divRole.Division.DivisionCode.Equals(entry.DivisionCode))
						{
							lvUserDivisionRoles.Items.Add(new DivisionRoleListViewItem(_divRole));
							break;
						}
					}
				}
			}

			DataLoadMode.Release();
		}

		/// <summary>
		/// </summary>
		private void PopulateUserDivisionsList()
		{
			DataLoadMode.Lock();

			if(this._vistAUser != null && this._vistAUser.AvailableDivisionsHashedByCode != null)
			{
				GuiUtility.PopulateComboBoxFromList(cmbDivisionCode, _vistAUser.AvailableDivisionsHashedByCode.Values, "DivisionCode");
				GuiUtility.PopulateComboBoxFromList(cmbDivisionName, _vistAUser.AvailableDivisionsHashedByCode.Values, "DivisionName");
			}

			DataLoadMode.Release();
		}

		/// <summary>
		/// </summary>
		private void ClearUserDivisionRolesListViewItems()
		{
			lvUserDivisionRoles.Items.Clear();
			DivisionRoleListViewItem.ClearAllItems();
		}

		/// <summary>
		/// Public property for containing forms to determine how many Divisions are currently in the listview (whether active or inactive)
		/// CR2315
		/// </summary>
		public int UserDivisionRolesCount
		{
			get
			{
				return(this.lvUserDivisionRoles.Items.Count);
			}
		}

		/// <summary>
		/// </summary>
		private void lvUserDivisionRoles_ItemCheck(object sender, ItemCheckEventArgs e)
		{
			if( DataLoadMode.IsLocked )
				return;			

			DivisionRoleListViewItem _lvi = ((DivisionRoleListViewItem)lvUserDivisionRoles.Items[ e.Index ]);

			DataLoadMode.Lock();

			_lvi.DivisionRole.IsActive = (e.NewValue == CheckState.Checked);
			_lvi.SyncWithDataObject();

			if( _lvi.Selected )
				cbActiveUserRole.Checked = _lvi.DivisionRole.IsActive;

			DataLoadMode.Release();

			SelectUserDivisionRole( _lvi == null ? null : _lvi.DivisionRole );

			OnDataChanged();
		}

		/// <summary>
		/// </summary>
		void lvUserDivisionRoles_SelectedIndexChanged(object sender, EventArgs e)
		{
			if( DataLoadMode.IsLocked )
				return;			

			DivisionRoleListViewItem _lvi = GetSelectedListViewItem();

			SelectUserDivisionRole( _lvi == null ? null : _lvi.DivisionRole );
			//CR1977
			SelectUserDivision( _lvi == null ? null : _lvi.DivisionRole.Division);

		}

		/// <summary>
		/// </summary>
		private void SelectUserDivisionRole( VbecsUserDivisionRole divisionRole )
		{
			if( DataLoadMode.IsLocked )
				return;

			if( divisionRole == null )
				ResetToNoDivisionRoleSelected();
			else		
				DisplayUserDivisionRole( divisionRole );
		}

		/// <summary>
		/// CR1977
		/// </summary>
		private void SelectUserDivision( BOL.Division division )
		{
			if( DataLoadMode.IsLocked )
				return;

			DataLoadMode.Lock();

			if (division == null)
			{
				cmbDivisionCode.SelectedItem = null;
				cmbDivisionName.SelectedItem = null;
			}
			else
			{
				cmbDivisionCode.SelectedIndex = cmbDivisionCode.FindStringExact(division.DivisionCode);
			}

			DataLoadMode.Release();

			UpdateDynamicallyEnabled();
		}

		/// <summary>
		/// </summary>
		private void DisplayRoleDetails( VbecsUserDivisionRole divisionRole )
		{
			if( divisionRole == null )
				throw( new ArgumentNullException( "divisionRole" ) );

			DataLoadMode.Lock();

			cmbDivisionCode.SelectedItem = divisionRole.Division;
			cmbUserRole.SelectedIndex = ( divisionRole.Role == null ) ? -1 : cmbUserRole.FindStringExact( divisionRole.Role.UserRoleName );
			cbActiveUserRole.Checked = divisionRole.IsActive;

			DataLoadMode.Release();
		}

		/// <summary>
		/// </summary>
		private void SelectRoleInListView( VbecsUserDivisionRole divisionRole ) 
		{
			if( divisionRole == null )
				throw( new ArgumentNullException( "divisionRole" ) );

			DataLoadMode.Lock();

			DivisionRoleListViewItem _lvi = DivisionRoleListViewItem.GetListViewItemByDivisionRole( divisionRole );
			
			if( _lvi != null )
			{
				_lvi.Selected = true;
				_lvi.EnsureVisible();
			}
			else
			{
				lvUserDivisionRoles.SelectedItems.Clear();
			}

			DataLoadMode.Release();
		}

		/// <summary>
		/// </summary>
		private void DisplayUserDivisionRole( VbecsUserDivisionRole divisionRole )
		{
			if( divisionRole == null )
				throw( new ArgumentNullException( "divisionRole" ) );

			DisplayRoleDetails( divisionRole );
			SelectRoleInListView( divisionRole );
			UpdateDynamicallyEnabled();
		}

		/// <summary>
		/// </summary>
		private DivisionRoleListViewItem GetSelectedListViewItem()
		{
			return lvUserDivisionRoles.SelectedItems.Count == 1 ? (DivisionRoleListViewItem)(lvUserDivisionRoles.SelectedItems[0]) : null;
		}

		/// <summary>
		/// </summary>
		private void btnUpdate_Click(object sender, EventArgs e)
		{
			string divisionCode = ((DivisionDefinition)cmbDivisionCode.SelectedItem).DivisionCode;
			//
			VbecsUserDivisionRole _divisionRole = (VbecsUserDivisionRole)_vbecsUser.DivisionsAndRoles[divisionCode];			
			//
			if(_divisionRole == null)
			{
				_vbecsUser.DivisionsAndRoles.Add(new VbecsUserDivisionRole(new Division(divisionCode)));
				//
				_divisionRole = (VbecsUserDivisionRole)_vbecsUser.DivisionsAndRoles[divisionCode];
			}
			//
			_divisionRole.Role = (UserRole)cmbUserRole.SelectedItem;
			_divisionRole.IsActive = cbActiveUserRole.Checked;

			DivisionRoleListViewItem _lvi = GetSelectedListViewItem();

			if( _lvi == null )
			{
				_lvi = new DivisionRoleListViewItem( _divisionRole );
				lvUserDivisionRoles.Items.Add( _lvi );
			}
			else
			{
				_lvi.SyncWithDataObject();
			}

			SelectUserDivisionRole( _divisionRole );

			OnDataChanged();


			//			VbecsUserDivisionRole _divisionRole = (VbecsUserDivisionRole)_vbecsUser.DivisionsAndRoles[ ((DivisionDefinition)cmbDivisionCode.SelectedItem).DivisionCode ];			
			//						
			//			_divisionRole.Role = (UserRole)cmbUserRole.SelectedItem;
			//			_divisionRole.IsActive = cbActiveUserRole.Checked;
			//
			//			DivisionRoleListViewItem _lvi = GetSelectedListViewItem();
			//
			//			if( _lvi == null )
			//			{
			//				_lvi = new DivisionRoleListViewItem( _divisionRole );
			//				lvUserDivisionRoles.Items.Add( _lvi );
			//			}
			//			else
			//			{
			//				_lvi.SyncWithDataObject();
			//			}
			//
			//			SelectUserDivisionRole( _divisionRole );
			//
			//			OnDataChanged();
		}

		/// <summary>
		/// </summary>
		private void btnVistaDivisions_Click(object sender, EventArgs e)
		{
			dlgVistADivisions _dlg = new dlgVistADivisions( 
				_vistAUser != null ? _vistAUser.AvailableDivisionsHashedByCode.Values : null, 
				cmbDivisionCode.SelectedItem != null ? ((DivisionDefinition)cmbDivisionCode.SelectedItem).DivisionCode : null );

			if( ResultAfterHostRefresh( _dlg.ShowDialog( this ) != DialogResult.OK ) )
				return;

			VbecsUserDivisionRole _divisionRoleToSelect = _vbecsUser.DivisionsAndRoles[ _dlg.SelectedVistADivision.DivisionCode ];

			if( _divisionRoleToSelect == null )
			{
				_divisionRoleToSelect = new VbecsUserDivisionRole( new Division( _dlg.SelectedVistADivision.DivisionCode ) );
				_vbecsUser.DivisionsAndRoles.Add( _divisionRoleToSelect );

				PopulateUserDivisionsList();
			}

			SelectUserDivision(_divisionRoleToSelect.Division);
			SelectUserDivisionRole( _divisionRoleToSelect );
		}

		/// <summary>
		/// </summary>
		protected virtual void OnDataChanged()
		{
			if( ControlDataChanged != null )
				ControlDataChanged( this, EventArgs.Empty );
		}
	}
}